/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.pdraw.standard;

import CH.ifa.draw.framework.ConnectionFigure;
import CH.ifa.draw.framework.Figure;
import CH.ifa.draw.framework.FigureEnumeration;
import CH.ifa.draw.standard.FigureDrawInfo;
import CH.ifa.draw.standard.StandardDrawing;
import DE.siemens.ad.logo.app.Model;
import DE.siemens.ad.logo.app.ModelFileListener;
import DE.siemens.ad.logo.model.Block;
import DE.siemens.ad.logo.model.BlockConnector;
import DE.siemens.ad.logo.model.BlockSubstituteListener;
import DE.siemens.ad.logo.model.CommentManager;
import DE.siemens.ad.logo.model.DrawingProperties;
import DE.siemens.ad.logo.model.Hardware;
import DE.siemens.ad.logo.model.HardwareFactory;
import DE.siemens.ad.logo.model.InBlockConnector;
import DE.siemens.ad.logo.model.InputNamesManager;
import DE.siemens.ad.logo.model.OptionProperties;
import DE.siemens.ad.logo.model.OutBlockConnector;
import DE.siemens.ad.logo.model.WiringDiagram;
import DE.siemens.ad.logo.model.block.AsiInputBlock;
import DE.siemens.ad.logo.model.block.AsiOutputBlock;
import DE.siemens.ad.logo.model.block.DeputyBlock;
import DE.siemens.ad.logo.model.block.OutputBlock;
import DE.siemens.ad.logo.model.hardware.Unknown;
import DE.siemens.ad.logo.util.BlockEnumerator;
import DE.siemens.ad.logo.util.Language;
import DE.siemens.ad.logo.util.Log;
import DE.siemens.ad.logo.util.LogoError;
import DE.siemens.ad.logo.util.LogoProperties;
import DE.siemens.ad.logo.util.UntitledFile;
import DE.siemens.ad.pdraw.figures.BlockFigure;
import DE.siemens.ad.pdraw.figures.BlockIfcFigure;
import DE.siemens.ad.pdraw.figures.CutConnectFigure;
import DE.siemens.ad.pdraw.figures.FixedElbowConnection;
import DE.siemens.ad.pdraw.figures.InputCutConnectFigure;
import DE.siemens.ad.pdraw.figures.InputIfcFigure;
import DE.siemens.ad.pdraw.figures.OutputIfcFigure;
import DE.siemens.ad.pdraw.figures.PageLineFigure;
import DE.siemens.ad.pdraw.figures.constraints.ConnectionConstraint;
import DE.siemens.ad.pdraw.figures.constraints.ConnectionLineConstraint;
import DE.siemens.ad.pdraw.figures.constraints.ConnectorConstraint;
import DE.siemens.ad.pdraw.figures.constraints.CutConnectionFigureConstraint;
import DE.siemens.ad.pdraw.figures.constraints.CuttedConnectionConstraint;
import DE.siemens.ad.pdraw.simulation.OfflineInterpreter;
import DE.siemens.ad.pdraw.util.ZoomableFigure;
import DE.siemens.ad.udf.UDFBlock;
import DE.siemens.ad.udf.UDFBlockFigure;
import DE.siemens.ad.udf.UDFFactory;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.print.PageFormat;
import java.awt.print.Paper;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OptionalDataException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class LogoDrawing
extends StandardDrawing
implements Model,
BlockSubstituteListener,
PropertyChangeListener {
    private static final transient int HEIGHT = 9;
    public static final transient String DRAWING_SIZE_CHANGED = "drawingSizeChanged";
    protected transient boolean fModified = false;
    private static final long serialVersionUID = -7465237363970613568L;
    private int logoDrawingSerializedDataVersion = 8;
    protected WiringDiagram fWiringDiagram = null;
    protected OptionProperties fOptionProperties = null;
    protected DrawingProperties fDrawingProperties = null;
    public CommentManager fCommentManager = null;
    protected InputNamesManager fInputNamesManager = null;
    private transient int fMajorVersion = -1;
    protected transient int fMinorVersion = -1;
    protected transient PageFormat fPageFormat = null;
    protected int fPageOrientation = 0;
    protected double fPaperMarginX;
    protected double fPaperMarginY;
    protected double fPaperWidth;
    protected double fPaperHeight;
    protected double fPaperImageWidth;
    protected double fPaperImageHeight;
    protected double fLeftNotPrintable = 17.009999999999998;
    protected double fTopNotPrintable = 17.009999999999998;
    protected Dimension fImageableArea = new Dimension(783, 506);
    protected boolean fSimulationPaintingFinished = true;
    protected transient Vector fModelFileChangedListeners;
    protected transient File fFile;
    protected transient boolean fUnknownV2 = false;
    private double fPrintZoom = 0.0;

    public Figure removeFromDrawingWithoutModified(Figure figure) {
        boolean modified = this.isModified();
        Figure rw = this.removeFromDrawing(figure);
        this.setModified(modified);
        return rw;
    }

    public synchronized Figure addWithoutModified(Figure figure) {
        boolean modified = this.isModified();
        Figure rw = this.add(figure);
        this.setModified(modified);
        return rw;
    }

    public LogoDrawing() {
        this.fOptionProperties = new OptionProperties(this);
        this.changeViewSize();
        this.fCommentManager = new CommentManager();
        this.fInputNamesManager = new InputNamesManager(this);
        this.fInputNamesManager.setInputName("M8", Language.getString("block.Marker.startupFlag", "Initialization Flag"));
        this.fInputNamesManager.setInputName("M25", Language.getString("block.Marker.OnBoardLCD", "On board LCD backlight"));
        this.fInputNamesManager.setInputName("M26", Language.getString("block.Marker.TDLCD", "Logo!TD LCD backlight"));
        this.fInputNamesManager.setInputName("M27", Language.getString("block.Marker.MsgLanguage", "Message Language Flag"));
    }

    public void configComments() {
        this.fInputNamesManager.setInputName("M8", Language.getString("block.Marker.startupFlag", "Initialization Flag"));
        this.fInputNamesManager.setInputName("M25", Language.getString("block.Marker.OnBoardLCD", "On board LCD backlight"));
        this.fInputNamesManager.setInputName("M26", Language.getString("block.Marker.TDLCD", "Logo!TD LCD backlight"));
        this.fInputNamesManager.setInputName("M27", Language.getString("block.Marker.MsgLanguage", "Message Language Flag"));
    }

    public void addModelFileListener(ModelFileListener vncl) {
        if (!this.getModelFileChangedListeners().contains(vncl)) {
            this.getModelFileChangedListeners().add(vncl);
        }
    }

    public void changeViewSize() {
        this.setChanged();
        this.notifyObservers(DRAWING_SIZE_CHANGED);
        this.updateCuttedConnectionLabels();
    }

    public void checkAndRepairModel(InputIfcFigure iiF, FixedElbowConnection feC) {
        InBlockConnector ibc = (InBlockConnector)iiF.getBlockConnector();
        if (ibc.isConnectable()) {
            OutBlockConnector obc = null;
            Figure f = feC.start().owner();
            if (f instanceof OutputIfcFigure) {
                obc = (OutBlockConnector)((OutputIfcFigure)f).getBlockConnector();
            } else {
                CutConnectFigure ccF = ((CutConnectFigure)f).getPartner();
                FixedElbowConnection feC2 = ccF.getConnectionFigure();
                obc = (OutBlockConnector)((OutputIfcFigure)feC2.start().owner()).getBlockConnector();
            }
            ibc.connect(obc);
        }
    }

    private void checkCommentManagerVsDrawing() {
    }

    public void checkConnectionsVsModel() {
        FigureEnumeration enumeration = this.figures();
        while (enumeration.hasMoreElements()) {
            FixedElbowConnection feC;
            Figure f = enumeration.nextFigure();
            if (!(f instanceof FixedElbowConnection) || !((f = (feC = (FixedElbowConnection)f).end().owner()) instanceof InputIfcFigure)) continue;
            this.checkAndRepairModel((InputIfcFigure)f, feC);
        }
    }

    private long computeCommonStartRouteLength(FixedElbowConnection c1, FixedElbowConnection c2, Point lastCommonPoint) {
        Point pointLine1 = null;
        Point pointLine2 = null;
        if (!c1.pointAt(0).equals(c2.pointAt(0))) {
            lastCommonPoint = null;
            return -1L;
        }
        Point commonPoint = new Point(c1.pointAt(0));
        long distance = 0L;
        int indexLine1 = 1;
        int indexLine2 = 1;
        while (indexLine1 < c1.pointCount() && indexLine2 < c2.pointCount()) {
            if (indexLine1 == 1 && c1.pointAt(indexLine1).equals(c1.pointAt(indexLine1 + 1))) {
                indexLine1 += 2;
            }
            if (indexLine2 == 1 && c2.pointAt(indexLine2).equals(c2.pointAt(indexLine2 + 1))) {
                indexLine2 += 2;
            }
            pointLine1 = c1.pointAt(indexLine1++);
            pointLine2 = c2.pointAt(indexLine2++);
            if ((pointLine1.x - commonPoint.x) * (pointLine2.x - commonPoint.x) >= 0) {
                int point1xd = Math.abs(pointLine1.x - commonPoint.x);
                int point2xd = Math.abs(pointLine2.x - commonPoint.x);
                distance += (long)Math.min(point1xd, point2xd);
                commonPoint.x = point1xd < point2xd ? pointLine1.x : pointLine2.x;
            }
            if ((pointLine1.y - commonPoint.y) * (pointLine2.y - commonPoint.y) >= 0) {
                int point1yd = Math.abs(pointLine1.y - commonPoint.y);
                int point2yd = Math.abs(pointLine2.y - commonPoint.y);
                distance += (long)Math.min(point1yd, point2yd);
                commonPoint.y = point1yd < point2yd ? pointLine1.y : pointLine2.y;
            }
            if (!pointLine1.equals(pointLine2)) break;
            commonPoint = new Point(pointLine1);
        }
        lastCommonPoint.x = commonPoint.x;
        lastCommonPoint.y = commonPoint.y;
        return distance;
    }

    private long computeCommonEndRouteLength(FixedElbowConnection c1, FixedElbowConnection c2, Point lastCommonPoint) {
        Point pointLine1 = null;
        Point pointLine2 = null;
        Point commonPoint = new Point(c1.pointAt(c1.pointCount() - 1));
        long distance = 0L;
        int indexLine1 = c1.pointCount() - 2;
        int indexLine2 = c2.pointCount() - 2;
        while (indexLine1 >= 0 && indexLine2 >= 0) {
            if (indexLine1 == 2 && c1.pointAt(indexLine1).equals(c1.pointAt(indexLine1 - 1))) {
                indexLine1 -= 2;
            }
            if (indexLine2 == 2 && c2.pointAt(indexLine2).equals(c2.pointAt(indexLine2 - 1))) {
                indexLine2 -= 2;
            }
            pointLine1 = c1.pointAt(indexLine1--);
            pointLine2 = c2.pointAt(indexLine2--);
            if ((pointLine1.x - commonPoint.x) * (pointLine2.x - commonPoint.x) >= 0) {
                int point1xd = Math.abs(pointLine1.x - commonPoint.x);
                int point2xd = Math.abs(pointLine2.x - commonPoint.x);
                distance += (long)Math.min(point1xd, point2xd);
                commonPoint.x = point1xd < point2xd ? pointLine1.x : pointLine2.x;
            }
            if ((pointLine1.y - commonPoint.y) * (pointLine2.y - commonPoint.y) >= 0) {
                int point1yd = Math.abs(pointLine1.y - commonPoint.y);
                int point2yd = Math.abs(pointLine2.y - commonPoint.y);
                distance += (long)Math.min(point1yd, point2yd);
                commonPoint.y = point1yd < point2yd ? pointLine1.y : pointLine2.y;
            }
            if (!pointLine1.equals(pointLine2)) break;
            commonPoint = new Point(pointLine1);
        }
        lastCommonPoint.x = commonPoint.x;
        lastCommonPoint.y = commonPoint.y;
        return distance;
    }

    public void constructConstraint() {
        Enumeration figureEnumeration = this.figures();
        Vector figures = new Vector();
        while (figureEnumeration.hasMoreElements()) {
            figures.add(figureEnumeration.nextElement());
        }
        figureEnumeration = figures.elements();
        Figure figure = null;
        while (figureEnumeration.hasMoreElements()) {
            figure = (Figure)figureEnumeration.nextElement();
            if (!(figure instanceof InputCutConnectFigure) || figure.getConstraint().getContainer() != null) continue;
            figure.getConstraint().setDrawing(this);
            CuttedConnectionConstraint cuttedConnectionConstraint = new CuttedConnectionConstraint();
            cuttedConnectionConstraint.setDrawing(this);
            ConnectionLineConstraint inputLineConstraint = ((CutConnectionFigureConstraint)figure.getConstraint()).getConnectionLineConstraint();
            inputLineConstraint.setDrawing(this);
            cuttedConnectionConstraint.addChildConstraint(inputLineConstraint);
            cuttedConnectionConstraint.addChildConstraint(figure.getConstraint());
            cuttedConnectionConstraint.connectWithOutput(inputLineConstraint.getOutBlockConnector());
            CutConnectionFigureConstraint partner = (CutConnectionFigureConstraint)((CutConnectFigure)figure).getPartner().getConstraint();
            partner.setDrawing(this);
            ConnectionLineConstraint outputLineConstraint = partner.getConnectionLineConstraint();
            outputLineConstraint.setDrawing(this);
            cuttedConnectionConstraint.addChildConstraint(outputLineConstraint);
            cuttedConnectionConstraint.addChildConstraint(partner);
            cuttedConnectionConstraint.connectWithInput(outputLineConstraint.getInBlockConnector());
            cuttedConnectionConstraint.setDirectConnection(null);
            cuttedConnectionConstraint.delete();
            cuttedConnectionConstraint.insert(this);
        }
    }

    public void draw(Graphics g) {
        super.draw(g);
        this.drawConnectionPoints(g);
    }

    public void draw(Graphics g, FigureDrawInfo fdi) {
        super.draw(g, fdi);
        this.drawConnectionPoints(g);
    }

    public void drawConnectionPoints(Graphics g) {
        Hashtable outputConnectionsDict = this.getOutputConnectionsDict();
        Hashtable inputConnectionsDict = this.getInputConnectionsDict();
        Vector v = null;
        Point lastCommonPoint = new Point(0, 0);
        Enumeration oce = outputConnectionsDict.elements();
        while (oce.hasMoreElements()) {
            v = (Vector)oce.nextElement();
            for (int j = 0; j < v.size() - 1; ++j) {
                for (int k = j + 1; k < v.size(); ++k) {
                    this.computeCommonStartRouteLength((FixedElbowConnection)v.elementAt(j), (FixedElbowConnection)v.elementAt(k), lastCommonPoint);
                    if (lastCommonPoint == null) continue;
                    g.setColor(Color.black);
                    g.fillOval(lastCommonPoint.x - 4, lastCommonPoint.y - 4, 8, 8);
                }
            }
        }
        Enumeration ice = inputConnectionsDict.elements();
        while (ice.hasMoreElements()) {
            v = (Vector)ice.nextElement();
            for (int j = 0; j < v.size() - 1; ++j) {
                for (int k = j + 1; k < v.size(); ++k) {
                    this.computeCommonEndRouteLength((FixedElbowConnection)v.elementAt(j), (FixedElbowConnection)v.elementAt(k), lastCommonPoint);
                    g.setColor(Color.black);
                    g.fillOval(lastCommonPoint.x - 4, lastCommonPoint.y - 4, 8, 8);
                }
            }
        }
    }

    protected Hashtable getInputConnectionsDict() {
        Hashtable inputConnectionsDict = new Hashtable();
        FigureEnumeration enumeration = this.figures();
        while (enumeration.hasMoreElements()) {
            FixedElbowConnection currentConnection;
            Figure f = enumeration.nextFigure();
            if (!(f instanceof FixedElbowConnection) || !((f = (currentConnection = (FixedElbowConnection)f).endFigure()) instanceof InputIfcFigure)) continue;
            if (!inputConnectionsDict.containsKey(f)) {
                inputConnectionsDict.put(f, new Vector());
            }
            ((Vector)inputConnectionsDict.get(f)).add(currentConnection);
        }
        return inputConnectionsDict;
    }

    protected Hashtable getOutputConnectionsDict() {
        Hashtable outputConnectionsDict = new Hashtable();
        FigureEnumeration enumeration = this.figures();
        while (enumeration.hasMoreElements()) {
            FixedElbowConnection currentConnection;
            Figure f = enumeration.nextFigure();
            if (!(f instanceof FixedElbowConnection) || !((f = (currentConnection = (FixedElbowConnection)f).startFigure()) instanceof OutputIfcFigure)) continue;
            if (!outputConnectionsDict.containsKey(f)) {
                outputConnectionsDict.put(f, new Vector());
            }
            ((Vector)outputConnectionsDict.get(f)).add(currentConnection);
        }
        return outputConnectionsDict;
    }

    public void drawSimulation(Graphics g, boolean showSignalStates, boolean showParameterValues) {
        Figure f;
        FigureEnumeration k = this.figures();
        Rectangle r = g.getClipBounds();
        if (showSignalStates) {
            while (k.hasMoreElements()) {
                f = k.nextFigure();
                if (r != null && !r.intersects(f.displayBox())) continue;
                f.drawSimulation1(g);
            }
        }
        if (showParameterValues) {
            k = this.figures();
            while (k.hasMoreElements()) {
                f = k.nextFigure();
                if (r != null && !r.intersects(f.displayBox())) continue;
                f.drawSimulation2(g);
            }
        }
        this.fSimulationPaintingFinished = true;
    }

    public void fireModelFileChangedEvent(File oldFile, File newFile) {
        Vector clone = (Vector)this.getModelFileChangedListeners().clone();
        Enumeration e = clone.elements();
        while (e.hasMoreElements()) {
            ((ModelFileListener)e.nextElement()).modelFileChanged(this, oldFile, newFile);
        }
    }

    public void fireModelSavedStatusChangedEvent(boolean oldStatus, boolean newStatus) {
        Vector clone = (Vector)this.getModelFileChangedListeners().clone();
        Enumeration e = clone.elements();
        while (e.hasMoreElements()) {
            ((ModelFileListener)e.nextElement()).modelFileSavedStatusChanged(this, oldStatus, newStatus);
        }
    }

    public BlockFigure getBlockFigure(Block block) {
        if (block instanceof DeputyBlock) {
            block = ((DeputyBlock)block).getParent();
        }
        FigureEnumeration e = this.figures();
        Figure figure = null;
        while (e.hasMoreElements()) {
            figure = e.nextFigure();
            if (!(figure instanceof BlockFigure) || ((BlockFigure)figure).getBlock() != block) continue;
            return (BlockFigure)figure;
        }
        return null;
    }

    public BlockIfcFigure getBlockIfcFigure(BlockConnector connector) {
        BlockIfcFigure figure = null;
        BlockFigure blockFigure = this.getBlockFigure(connector.getOwner());
        if (blockFigure != null) {
            figure = connector instanceof InBlockConnector ? blockFigure.getInputIfcFigure(connector) : blockFigure.getOutputIfcFigure(connector);
        }
        return figure;
    }

    public Vector getBlockFigures(String blockNumberString) {
        Vector<Figure> blockFigures = new Vector<Figure>(5);
        FigureEnumeration e = this.figures();
        Figure figure = null;
        while (e.hasMoreElements()) {
            figure = e.nextFigure();
            if (!(figure instanceof BlockFigure) || !((BlockFigure)figure).getBlock().getNumberString().equals(blockNumberString)) continue;
            blockFigures.add(figure);
        }
        return blockFigures;
    }

    public CommentManager getCommentManager() {
        return this.fCommentManager;
    }

    public Vector getFiguresIntersectRectangle(Rectangle r) {
        Vector<Figure> retVector = new Vector<Figure>();
        FigureEnumeration k = this.figuresReverse();
        while (k.hasMoreElements()) {
            Figure figure = k.nextFigure();
            if (!figure.intersectsRectangle(r)) continue;
            retVector.addElement(figure);
        }
        return retVector;
    }

    public Vector getFiguresIntersectRectangleWithout(Rectangle r, Figure without) {
        Vector<Figure> retVector = new Vector<Figure>();
        FigureEnumeration k = this.figuresReverse();
        while (k.hasMoreElements()) {
            Figure figure = k.nextFigure();
            if (!figure.intersectsRectangle(r) || figure.includes(without)) continue;
            retVector.addElement(figure);
        }
        return retVector;
    }

    public File getFile() {
        if (this.fFile == null) {
            this.fFile = new UntitledFile();
        }
        return this.fFile;
    }

    public InputNamesManager getInputNamesManager() {
        return this.fInputNamesManager;
    }

    public Vector getModelFileChangedListeners() {
        if (this.fModelFileChangedListeners == null) {
            this.fModelFileChangedListeners = new Vector(2);
        }
        return this.fModelFileChangedListeners;
    }

    public OptionProperties getOptionProperties() {
        return this.fOptionProperties;
    }

    public PageFormat getPageFormat() {
        if (this.fPageFormat == null) {
            Paper paper = new Paper();
            paper.setImageableArea(this.fPaperMarginX, this.fPaperMarginY, this.fPaperImageWidth, this.fPaperImageHeight);
            paper.setSize(this.fPaperWidth, this.fPaperHeight);
            this.fPageFormat = new PageFormat();
            this.fPageFormat.setOrientation(this.fPageOrientation);
            this.fPageFormat.setPaper(paper);
        }
        return (PageFormat)this.fPageFormat.clone();
    }

    public int getPageNumber(int x, int y) {
        int horPages = this.getWiringDiagram().getDrawingProperties().getPagesHorizontal();
        Dimension pageDim = this.getPageDimension();
        int pageWidth = (int)((double)pageDim.width / this.getPrintZoom());
        int pageHeight = (int)((double)pageDim.height / this.getPrintZoom());
        int indexHorizontal = x / pageWidth + 1;
        int indexVertical = y / pageHeight * horPages;
        return indexHorizontal + indexVertical;
    }

    public Dimension getMinimumSize() {
        Dimension result = super.getMinimumSize();
        result.width = (int)((double)result.width * this.getPrintZoom());
        result.height = (int)((double)result.height * this.getPrintZoom());
        return result;
    }

    public Dimension getPageDimension() {
        return this.fImageableArea;
    }

    public String getStorePath() {
        if (this.getFile() == null) {
            return null;
        }
        return this.getFile().getPath();
    }

    public Dimension getViewSize100() {
        DrawingProperties prop = this.getWiringDiagram().getDrawingProperties();
        int hPages = prop.getPagesHorizontal();
        int vPages = prop.getPagesVertical();
        return new Dimension((int)((double)(this.fImageableArea.width * hPages) / this.getPrintZoom()), (int)((double)(this.fImageableArea.height * vPages) / this.getPrintZoom()));
    }

    public WiringDiagram getWiringDiagram() {
        if (this.fWiringDiagram == null) {
            Hardware hardware = null;
            try {
                String hardwareString = LogoProperties.instance().getProperty("hardware", "Unknown");
                hardware = HardwareFactory.getInstance().createInstance(hardwareString);
            }
            catch (IOException ioe) {
                hardware = null;
            }
            this.setWiringDiagram(new WiringDiagram(hardware));
        }
        return this.fWiringDiagram;
    }

    public boolean isRecursionFree() {
        Block currentBlock = null;
        Block startBlock = null;
        Vector alreadyChecked = new Vector(56);
        Vector<Block> currentLoop = new Vector<Block>(10);
        boolean recursionFree = true;
        boolean retValue = true;
        FigureEnumeration enumeration = this.figures();
        while (recursionFree && enumeration.hasMoreElements()) {
            Figure f = enumeration.nextFigure();
            if (!(f instanceof BlockFigure) || alreadyChecked.contains(currentBlock = ((BlockFigure)f).getBlock())) continue;
            startBlock = currentBlock;
            currentLoop.removeAllElements();
            recursionFree = true;
            if (currentBlock instanceof OutputBlock) continue;
            BlockEnumerator enum2 = new BlockEnumerator(currentBlock, false);
            currentBlock = enum2.nextBlock();
            while (recursionFree && enum2.hasMoreElements()) {
                currentBlock = enum2.nextBlock();
                if (currentBlock.equals(startBlock)) {
                    recursionFree = false;
                    retValue = false;
                    String errorString = Language.getString("error.recursion", "Recursion from block %", startBlock.getNumberString());
                    Log.println(errorString);
                    new LogoError(errorString).display();
                    continue;
                }
                currentLoop.addElement(currentBlock);
            }
        }
        return retValue;
    }

    public boolean isSimulationPaintingFinished() {
        return this.fSimulationPaintingFinished;
    }

    private PageFormat getPageFormatFromOldDrawingVersion() {
        PageFormat oldFormat = new PageFormat();
        Paper oldPaper = new Paper();
        oldPaper.setSize(this.fPaperWidth, this.fPaperHeight);
        oldPaper.setImageableArea(this.fPaperMarginX, this.fPaperMarginY, this.fPaperImageWidth, this.fPaperImageHeight);
        oldFormat.setPaper(oldPaper);
        PageFormat drawingFormat = oldFormat;
        PageFormat pf = (PageFormat)drawingFormat.clone();
        Paper drawingPaper = drawingFormat.getPaper();
        double links = drawingPaper.getImageableX() + this.fLeftNotPrintable;
        double rechts = drawingPaper.getWidth() - links - drawingPaper.getImageableWidth();
        double oben = drawingPaper.getImageableY() + this.fTopNotPrintable;
        Paper paper = (Paper)drawingPaper.clone();
        if (drawingFormat.getWidth() > drawingFormat.getHeight()) {
            paper.setSize(drawingFormat.getHeight(), drawingFormat.getWidth());
            paper.setImageableArea(oben, rechts, drawingPaper.getImageableHeight(), drawingPaper.getImageableWidth());
            pf.setOrientation(0);
            pf.setPaper(paper);
        } else {
            paper.setImageableArea(links, oben, drawingPaper.getImageableWidth(), drawingPaper.getImageableHeight());
            pf.setOrientation(1);
            pf.setPaper(paper);
        }
        return pf;
    }

    public boolean isUnknownV2() {
        return this.fUnknownV2;
    }

    public void modifyChangedDate() {
        this.getWiringDiagram().getDrawingProperties().setChanged();
    }

    public void propertyChange(PropertyChangeEvent event) {
        String propertyName = event.getPropertyName();
        if (propertyName == "pageHor" || propertyName == "pageVer") {
            this.changeViewSize();
        }
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        File file = this.fFile;
        this.fFile = null;
        s.defaultWriteObject();
        this.fFile = file;
    }

    private void readObject(ObjectInputStream s) throws ClassNotFoundException, IOException {
        try {
            s.defaultReadObject();
        }
        catch (OptionalDataException optionalDataException) {
            optionalDataException.printStackTrace();
        }
        WiringDiagram wd = this.getWiringDiagram();
        wd.addBlockSubstituteListener(this);
        Enumeration enumeration = wd.getBlocks().elements();
        ArrayList<Block> asiBlocks = null;
        OfflineInterpreter interpreter = new OfflineInterpreter(this);
        while (enumeration.hasMoreElements()) {
            Block block = (Block)enumeration.nextElement();
            if (block instanceof AsiInputBlock || block instanceof AsiOutputBlock) {
                if (asiBlocks == null) {
                    asiBlocks = new ArrayList<Block>(8);
                }
                asiBlocks.add(block);
                continue;
            }
            block.init(interpreter, true);
        }
        if (this.logoDrawingSerializedDataVersion < 2) {
            this.checkConnectionsVsModel();
            this.isRecursionFree();
        }
        if (this.logoDrawingSerializedDataVersion < 3) {
            this.checkCommentManagerVsDrawing();
        }
        if (this.logoDrawingSerializedDataVersion < 4) {
            wd.setDrawingProperties(this.fDrawingProperties);
            Enumeration allBlocks = wd.getBlocks().elements();
            while (allBlocks.hasMoreElements()) {
                Block block = (Block)allBlocks.nextElement();
                InBlockConnector[] connectors = block.getInConnectors();
                if (connectors == null) continue;
                for (int i = 0; i < connectors.length; ++i) {
                    connectors[i].postReadObject();
                }
            }
        }
        DrawingProperties prop = wd.getDrawingProperties();
        if (this.logoDrawingSerializedDataVersion < 5) {
            Vector<Figure> figuresToRemove = new Vector<Figure>();
            Figure f = null;
            FigureEnumeration figures = this.figures();
            while (figures.hasMoreElements()) {
                f = figures.nextFigure();
                if (f instanceof ZoomableFigure) {
                    ((ZoomableFigure)((Object)f)).zoomChanged(100);
                }
                if (!(f instanceof PageLineFigure)) continue;
                figuresToRemove.add(f);
            }
            this.updateConnections();
            Enumeration toRemove = figuresToRemove.elements();
            while (toRemove.hasMoreElements()) {
                this.remove((Figure)toRemove.nextElement());
            }
            Hardware hw = wd.getHardware();
            if (hw instanceof Unknown) {
                this.setUnknownV2(true);
            }
            prop.setPagesHorizontal(this.fOptionProperties.getPagesHorizontal());
            prop.setPagesVertical(this.fOptionProperties.getPagesVertical());
        }
        if (this.logoDrawingSerializedDataVersion < 6) {
            this.fPageFormat = this.getPageFormatFromOldDrawingVersion();
        }
        if (this.logoDrawingSerializedDataVersion < 7) {
            this.updateConnections();
            this.getInputNamesManager().setInputName("M8", Language.getString("block.Marker.startupFlag", "Initialization Flag"));
        }
        if (this.logoDrawingSerializedDataVersion < 8) {
            this.getInputNamesManager().setInputName("M25", Language.getString("block.Marker.OnBoardLCD", "On board LCD backlight"));
            this.getInputNamesManager().setInputName("M26", Language.getString("block.Marker.TDLCD", "Logo!TD LCD backlight"));
            this.getInputNamesManager().setInputName("M27", Language.getString("block.Marker.MsgLanguage", "Message Language Flag"));
        }
        prop.addPropertyChangeListener(this);
        this.getInputNamesManager().setDrawing(this);
        this.logoDrawingSerializedDataVersion = 8;
        this.fModified = false;
    }

    public void registerListeners() {
        FigureEnumeration fe = this.figures();
        Figure figure = null;
        BlockFigure blockFigure = null;
        while (fe.hasMoreElements()) {
            figure = fe.nextFigure();
            if (!(figure instanceof BlockFigure) || (blockFigure = (BlockFigure)figure).getBlock() == null || blockFigure.getBlock().getParameter() == null) continue;
            blockFigure.getBlock().getParameter().addParameterSetListener(blockFigure);
            blockFigure.getBlock().addBlockNameChangedListener(blockFigure);
        }
    }

    public void removeModelFileListener(ModelFileListener mfcl) {
        this.getModelFileChangedListeners().remove(mfcl);
    }

    public void setDefaultPage() {
        LogoProperties props = LogoProperties.instance();
        PageFormat pageFormat = new PageFormat();
        Paper paper = new Paper();
        paper.setSize(props.getDoubleProperty("pageFormat.paper.width", 595.0), props.getDoubleProperty("pageFormat.paper.height", 842.0));
        paper.setImageableArea(props.getDoubleProperty("pageFormat.margin.left", 28.0), props.getDoubleProperty("pageFormat.margin.top", 28.0), props.getDoubleProperty("pageFormat.imagesize.width", 538.0), props.getDoubleProperty("pageFormat.imagesize.height", 785.0));
        pageFormat.setPaper(paper);
        pageFormat.setOrientation(props.getIntProperty("pageFormat.orientation", 0));
        this.setPageFormat(pageFormat);
        this.setLeftNotPrintable(props.getDoubleProperty("pageFormat.leftNotPrintable", this.fLeftNotPrintable));
        this.setTopNotPrintable(props.getDoubleProperty("pageFormat.topNotPrintable", this.fTopNotPrintable));
    }

    public void setFile(File file) {
        File oldFile = this.fFile;
        this.fFile = file;
        this.fireModelFileChangedEvent(oldFile, this.fFile);
    }

    private void setLeftNotPrintable(double newValue) {
        this.fLeftNotPrintable = newValue;
    }

    public void setPageFormat(PageFormat pageFormat) {
        this.fPageFormat = pageFormat;
        this.fPageOrientation = pageFormat.getOrientation();
        Paper paper = pageFormat.getPaper();
        this.fPaperMarginX = paper.getImageableX();
        this.fPaperMarginY = paper.getImageableY();
        this.fPaperWidth = paper.getWidth();
        this.fPaperHeight = paper.getHeight();
        this.fPaperImageWidth = paper.getImageableWidth();
        this.fPaperImageHeight = paper.getImageableHeight();
        this.fImageableArea = this.computeImageableArea(pageFormat);
        this.changeViewSize();
    }

    public Dimension computeImageableArea(PageFormat pageFormat) {
        return new Dimension((int)pageFormat.getImageableWidth() - 2, (int)pageFormat.getImageableHeight() - 27 - 2);
    }

    public void setSimulationPaintingFinished(boolean newSimulationPaintingFinished) {
        this.fSimulationPaintingFinished = newSimulationPaintingFinished;
    }

    public void setStorePath(String path) {
        super.setStorePath(path);
        this.setFile(new File(path));
    }

    private void setTopNotPrintable(double newValue) {
        this.fTopNotPrintable = newValue;
    }

    public void setUnknownV2(boolean newUnknownV2) {
        this.fUnknownV2 = newUnknownV2;
    }

    public void setWiringDiagram(WiringDiagram wd) {
        if (this.fWiringDiagram != null) {
            this.fWiringDiagram.removeBlockSubstituteListener(this);
            this.fWiringDiagram.getDrawingProperties().removePropertyChangeListener(this);
        }
        this.fWiringDiagram = wd;
        this.fWiringDiagram.addBlockSubstituteListener(this);
        this.fWiringDiagram.getDrawingProperties().addPropertyChangeListener(this);
    }

    public void substituteBlock(Block oldBlock, Block newBlock) {
        FixedElbowConnection fec;
        int i;
        BlockFigure oldBlockFigure = this.getBlockFigure(oldBlock);
        BlockFigure newBlockFigure = new BlockFigure(newBlock, oldBlockFigure.selectionBox().getLocation());
        newBlockFigure.displayBox(oldBlockFigure.displayBox());
        for (i = 0; i < oldBlock.getInConnectorCount(); ++i) {
            InBlockConnector currentOldInConnector = oldBlock.getInConnector(i);
            InputIfcFigure oldInputIfcFigure = oldBlockFigure.getInputIfcFigure(currentOldInConnector);
            for (ConnectionLineConstraint currentConnectionConstraint : ((ConnectorConstraint)oldInputIfcFigure.getConstraint()).getConnectionLineConstraints()) {
                fec = (FixedElbowConnection)currentConnectionConstraint.getFigure();
                fec.disconnectEnd();
                fec.connectEnd(newBlockFigure.getInputIfcFigure(newBlock.getInConnector(i)).connectorAt(0, 0));
                ((ConnectionConstraint)((Object)currentConnectionConstraint.getTopLevelConstraint())).getOutBlockConnector().disconnect(currentOldInConnector);
                ((ConnectionConstraint)((Object)currentConnectionConstraint.getTopLevelConstraint())).getOutBlockConnector().connect(newBlock.getInConnector(i));
                fec.updateConnection();
            }
        }
        for (i = 0; i < oldBlock.getOutConnectorCount(); ++i) {
            OutBlockConnector currentOldOutBlockConnector = oldBlock.getOutConnector(i);
            OutputIfcFigure oldOutputIfcFigure = oldBlockFigure.getOutputIfcFigure(currentOldOutBlockConnector);
            for (ConnectionLineConstraint currentConnectionConstraint : ((ConnectorConstraint)oldOutputIfcFigure.getConstraint()).getConnectionLineConstraints()) {
                fec = (FixedElbowConnection)currentConnectionConstraint.getFigure();
                fec.disconnectStart();
                fec.connectStart(newBlockFigure.getOutputIfcFigure(newBlock.getOutConnector(i)).connectorAt(0, 0));
                ((ConnectionConstraint)((Object)currentConnectionConstraint.getTopLevelConstraint())).getInBlockConnector().disconnect(currentOldOutBlockConnector);
                ((ConnectionConstraint)((Object)currentConnectionConstraint.getTopLevelConstraint())).getInBlockConnector().connect(newBlock.getOutConnector(i));
                fec.updateConnection();
            }
        }
        this.remove(oldBlockFigure);
        this.add(newBlockFigure);
        this.getWiringDiagram().deleteBlock(oldBlock);
        this.getWiringDiagram().insert(newBlock);
    }

    public void updateConnections() {
        FigureEnumeration e = this.figures();
        Figure f = null;
        while (e.hasMoreElements()) {
            f = e.nextFigure();
            if (!(f instanceof ConnectionFigure)) continue;
            ((ConnectionFigure)f).updateConnection();
        }
    }

    public void updateCutConnectFigures(String blockName) {
        FigureEnumeration enumeration = this.figures();
        while (enumeration.hasMoreElements()) {
            CutConnectFigure ccF;
            String text;
            Figure f = enumeration.nextFigure();
            if (!(f instanceof CutConnectFigure) || (text = (ccF = (CutConnectFigure)f).getDescription()) == null || text.indexOf(blockName) == -1) continue;
            ccF.setDescription(this);
            ccF.invalidate();
        }
        this.forceUpdate();
    }

    public void updateCuttedConnectionLabels() {
        FigureEnumeration fe = this.figures();
        Figure figure = null;
        while (fe.hasMoreElements()) {
            figure = fe.nextFigure();
            if (!(figure instanceof CutConnectFigure)) continue;
            ((CutConnectFigure)figure).setDescription(this);
        }
    }

    public void updateInputNames() {
        FigureEnumeration enumeration = this.figures();
        while (enumeration.hasMoreElements()) {
            String text;
            Figure f = enumeration.nextFigure();
            if (!(f instanceof BlockFigure) || (text = this.fInputNamesManager.getInputName(((BlockFigure)f).getBlock().getNumberString())) == null) continue;
            ((BlockFigure)f).updateInputName(text);
        }
    }

    public boolean isModified() {
        return this.fModified;
    }

    public void setModified(boolean modified) {
        if (modified) {
            this.getWiringDiagram().getDrawingProperties().setChanged();
        }
        if (modified == this.fModified) {
            return;
        }
        this.fireModelSavedStatusChangedEvent(this.fModified, modified);
        this.fModified = modified;
    }

    public double getLeftNotPrintable() {
        return this.fLeftNotPrintable;
    }

    public boolean isPageEmpty(int column, int row) {
        Dimension printPageDimension = new Dimension((int)((double)this.getPageDimension().width / this.fPrintZoom), (int)((double)this.getPageDimension().height / this.fPrintZoom));
        Rectangle pageRectangle = new Rectangle(new Point(column * printPageDimension.width, row * printPageDimension.height), printPageDimension);
        boolean empty = this.findFigure(pageRectangle) == null;
        return empty;
    }

    public double getPrintZoom() {
        if (this.fPrintZoom == 0.0) {
            this.fPrintZoom = LogoProperties.instance().getDoubleProperty("printZoom", 50.0) / 100.0;
        }
        return this.fPrintZoom;
    }

    public void setPrintZoom(double printZoom) {
        this.fPrintZoom = printZoom;
        this.setModified(true);
        this.changeViewSize();
    }

    public void updateUDFBlockState(boolean isUpload) {
        FigureEnumeration e = this.figures();
        while (e.hasMoreElements()) {
            Figure figure = e.nextFigure();
            if (!(figure instanceof UDFBlockFigure)) continue;
            UDFBlock block = (UDFBlock)((UDFBlockFigure)figure).getBlock();
            block.setState(UDFFactory.instance().getUDFBlockState(block.getGuid()));
            if (!isUpload || block.getState() != 0) continue;
            UDFBlock libBlock = UDFFactory.instance().getUDFBlock(this.fWiringDiagram, block.getGuid());
            for (int i = 0; i < block.getInConnectorCount() - 1; ++i) {
                block.getInConnector(i).setName(libBlock.getInConnector(i).getName());
            }
            for (int j = 0; j < block.getOutConnectorCount(); ++j) {
                block.getOutConnector(j).setName(libBlock.getOutConnector(j).getName());
            }
        }
    }
}

